#ifndef __HCMOVINGCIRCLES_H
#define __HCMOVINGCIRCLES_H

#include "stdafx.h"
#include "MovingCircle.h"
#include <ctime>

#include <list>
using std::list;
    
class HCMovingCircles {
    list<MovingCircle> circles;
    enum {FRAMETIMER = 555, FRAMESPERSECOND = 30, COUNT = 40,
            MINRADIUS = 10, MAXRADIUS = 30, MAXSPEED = 50};
    CWnd *pWnd;
public:
    void onInitialUpdate(CWnd *pWnd) {
        HCMovingCircles::pWnd = pWnd;
        CRect R;
        pWnd->GetClientRect(&R);
        srand(int(time(0)));
        for (int i=0; i<COUNT; ++i) {
            MovingCircle c;
            c.randomizeRadius(MINRADIUS,MAXRADIUS);
            c.randomizeCenter(R.left,R.right,R.top,R.bottom);
            c.randomizeDirection(MAXSPEED);
            c.randomizeColor();
            c.putFramesPerSecond(FRAMESPERSECOND);
            circles.push_back(c);
        }
        pWnd->SetTimer(FRAMETIMER,1000/FRAMESPERSECOND,0);
    }
	void onTimer() {
		for (list<MovingCircle>::iterator i=circles.begin(); 
				i!=circles.end(); ++i)
			++*i;
		bool changes = true;
		while (changes) {
			changes = false;
			list<MovingCircle>::iterator iCircleToErase;
			for (list<MovingCircle>::iterator i=circles.begin(); 
					!changes && i!=circles.end(); ++i)
				for (list<MovingCircle>::iterator j = i; 
						!changes && ++j != circles.end(); ) {
					if (touching(*i, *j)) {
						*i = *i + *j;
						iCircleToErase = j;
						changes = true;
					}
				}
			if (changes) circles.erase(iCircleToErase);
		}
		pWnd->Invalidate();
	}
    void onDestroy() {
        pWnd->KillTimer(FRAMETIMER);
    }
    void onDraw(CDC *pDC) {
        for (list<MovingCircle>::iterator i=circles.begin(); 
                i!=circles.end(); ++i) i->draw(*pDC);
    }
    void onFileNew() {
      CRect R;
      pWnd->GetClientRect(&R);
        bool changes = true;
        while (changes) {
            changes = false;
            list<MovingCircle>::iterator iCircleToErase;
            for (list<MovingCircle>::iterator i=circles.begin();
                 !changes && i!=circles.end(); ++i)
                int leftCircleEdge = i->getX() - i->getRadius(),
                    rightCircleEdge = i->getX() + i->getRadius(),
                    topCircleEdge = i->getY() - i->getRadius(),
                    bottomCircleEdge = i->getY() + i->getRadius();
                if (R.left > rightCircleEdge || 
                    R.right < leftCircleEdge ||
                    R.top > bottomCircleEdge || 
                    R.bottom < topCircleEdge) {
                    iCircleToErase = i;
                    changes = true;
                }
            }
            if (changes) circles.erase(iCircleToErase);
         }
    }
    void onSnapshot();
};

class HCSnapshotWnd {
    CWnd *pParent;
    CBitmap *bmp;
public:
    HCSnapshotWnd(CWnd *pParent, CBitmap *bmp): 
        pParent(pParent), bmp(bmp){}
    virtual void onPaint() {
        CRect R, SnapR;
        pParent->GetClientRect(&R);
        CWnd *pWnd = dynamic_cast<CWnd*>(this);
        pWnd->GetClientRect(&SnapR);
        CDC memDC;
        CClientDC parentDC(pParent);
        memDC.CreateCompatibleDC(&parentDC);
        memDC.SelectObject(bmp);
        CClientDC dc(pWnd);
        dc.StretchBlt(SnapR.left,SnapR.top,SnapR.Width(),
            SnapR.Height(),&memDC,0,0,R.Width(),R.Height(),
            SRCCOPY);
    }
    void onDestroy() {
        delete bmp;
    }
};

#endif
